
local function itemtest(inst, item, slot)
    if item.prefab == "cave_banana" or item.prefab == "pomegranate" or item.prefab == "dragonfruit" then
       return true
    end
    return false
end
local slotpos = { Vector3(0,32+4,0), Vector3(0,-(32+4),0), Vector3(0,-(64+32+8+4),0)}
local widgetbuttoninfo = {
    text = "Start",
    position = Vector3(0, -165, 0),
    fn = function(inst)
      if inst:HasTag("juicer") and inst.components.container:Has("cave_banana", 1) and inst.components.container:Has("pomegranate", 1) and inst.components.container:Has("dragonfruit", 1) then
         inst.components.container:ConsumeByName("cave_banana", 1)
         inst.components.container:ConsumeByName("pomegranate", 1)
         inst.components.container:ConsumeByName("dragonfruit", 1)
         GetPlayer().SoundEmitter:PlaySound("dontstarve/HUD/research_available")
         local sweets = SpawnPrefab("healingsalve")
         sweets.AnimState:SetBank("food")
         sweets.AnimState:SetBuild("cook_pot_food")
         sweets.AnimState:PlayAnimation("fruitmedley", false)
         sweets:RemoveComponent("stackable")
         sweets:RemoveComponent("deployable")
         sweets.components.healer:SetHealthAmount(TUNING.HEALING_SUPERHUGE)
         sweets.components.inventoryitem:ChangeImageName("fruitmedley")
         sweets.Transform:SetScale(1.2, 1.2, 1.2)
         sweets:AddTag("sweets")
         GetPlayer().components.inventory:GiveItem(sweets)
      end
    end }
    inst:AddComponent("container")
    inst.components.container.widgetbuttoninfo = widgetbuttoninfo
    inst.components.container:SetNumSlots(#slotpos)
    inst.components.container.widgetslotpos = slotpos
    inst.components.container.widgetpos = Vector3(0,180,0)
    inst.components.container.side_align_tip = 160
    inst.components.container.itemtestfn = itemtest
    inst.components.container.canbeopened = false
local function sweetshop(inst)
    local pt = inst:GetPosition()
    local shop = SpawnPrefab("healingsalve")
    shop.Transform:SetPosition(pt.x, pt.y, pt.z)
    shop.AnimState:SetBank("rabbithouse")
    shop.AnimState:SetBuild("rabbit_house")
    shop.AnimState:PlayAnimation("idle", true)
    shop.Transform:SetScale(0.8, 0.8, 0.8)
    shop:RemoveComponent("stackable")
    shop:RemoveComponent("inventoryitem")
    shop:RemoveComponent("healer")
    shop:RemoveComponent("deployable")
    local light = shop.entity:AddLight()
    light:SetFalloff(1)
    light:SetIntensity(.8)
    light:SetRadius(5)
    light:SetColour(180/255, 195/255, 50/255)
    light:Enable(true)
    MakeLargeBurnable(shop)
    MakeLargePropagator(shop)
    shop:AddTag("shop")
    shop:DoPeriodicTask(2, function(shop)
        shop.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
        shop:DoTaskInTime(1, function() shop.AnimState:SetBloomEffectHandle("") end )
    end )
    shop:AddComponent("trader")
    shop.components.trader:SetAcceptTest(function(shop, item) 
        if item.prefab == "goldnugget" then
           return true
        end
        return false
    end )
    shop.components.trader.onaccept = function(shop, giver, item)
        local names = {"cave_banana","pomegranate","dragonfruit"}
        local name = names[math.random(#names)]
        local veggie = SpawnPrefab(name)
        if item.prefab == "goldnugget" then
           giver.components.inventory:GiveItem(veggie)
        end
    end
    local counter = SpawnPrefab("healingsalve")
    counter.Transform:SetPosition(pt.x+2+1.8, 0, pt.z+2-1.8)
    counter.AnimState:SetBank("winter_meter")
    counter.AnimState:SetBuild("winter_meter")
    counter.AnimState:SetPercent("meter", 0)
    counter.Transform:SetScale(1.2, 1.2, 1.2)
    counter.AnimState:SetOrientation( ANIM_ORIENTATION.OnGround )
    counter.AnimState:SetLayer( LAYER_BACKGROUND )
    counter.AnimState:SetSortOrder( 1 )
    counter.Transform:SetRotation( 135 )
    counter.AnimState:SetMultColour(255/255,255/255,255/255,0)
    counter:RemoveComponent("stackable")
    counter:RemoveComponent("inventoryitem")
    counter:RemoveComponent("healer")
    counter:RemoveComponent("deployable")
    MakeLargeBurnable(counter)
    MakeLargePropagator(counter)
    counter:AddTag("NOCLICK")
    counter:AddTag("goodbye")
    local juicer = SpawnPrefab("healingsalve")
    juicer.Transform:SetPosition(pt.x+1-2, 0, pt.z+1+2)
    juicer.AnimState:SetBank("researchlab2")
    juicer.AnimState:SetBuild("researchlab2")
    juicer.AnimState:PlayAnimation("idle")
    juicer.Transform:SetScale(0.8, 0.8, 0.8)
    juicer.AnimState:SetMultColour(255/255,105/255,0/255,1)
    juicer:RemoveComponent("stackable")
    juicer:RemoveComponent("inventoryitem")
    juicer:RemoveComponent("healer")
    juicer:RemoveComponent("deployable")
    juicer.components.container.canbeopened = true
    MakeLargeBurnable(juicer)
    MakeLargePropagator(juicer)
    juicer:AddTag("juicer")
    juicer:AddTag("goodbye")
    local sweetsign = SpawnPrefab("healingsalve")
    sweetsign.Transform:SetPosition(pt.x+1+2, 0, pt.z+1-2)
    sweetsign.AnimState:SetBank("sign_home")
    sweetsign.AnimState:SetBuild("sign_home")
    sweetsign.AnimState:PlayAnimation("idle")
    sweetsign.Transform:SetScale(0.8, 0.8, 0.8)
    sweetsign.AnimState:SetMultColour(255/255,0/255,0/255,1)
    MakeLargeBurnable(sweetsign)
    MakeLargePropagator(sweetsign)
    sweetsign:AddTag("goodbye")
    sweetsign:RemoveComponent("stackable")
    sweetsign:RemoveComponent("inventoryitem")
    sweetsign:RemoveComponent("healer")
    sweetsign:RemoveComponent("deployable")
    sweetsign:ListenForEvent( "nighttime", function()
        sweetsign:RemoveTag("openshop")
        GetPlayer().SoundEmitter:KillSound("beavermusic")
        sweetsign.AnimState:SetMultColour(255/255,0/255,0/255,1)
        local pos = Vector3(sweetsign.Transform:GetWorldPosition())
        local ents = TheSim:FindEntities(pos.x,pos.y,pos.z, 3000)
        for k,v in pairs(ents) do
            if v:HasTag("customers") then
               v:Remove()
            end
        end
    end, GetWorld())
    sweetsign.components.inspectable.getstatus = function(sweetsign)
      if not sweetsign:HasTag("openshop") then
        local target0 = FindEntity(sweetsign, 10, function(guy) 
            return guy:HasTag("sweets") and guy.components.inventoryitem and not guy.components.inventoryitem:IsHeld()
        end )
        if target0 then
           sweetsign:AddTag("openshop")
           GetPlayer().SoundEmitter:PlaySound("dontstarve/music/music_hoedown", "beavermusic")
           sweetsign.AnimState:SetMultColour(0/255,255/255,0/255,1)
           for k = 1, math.random(8,16) do
               local pt1 = sweetsign:GetPosition()
               local customer = SpawnPrefab("healingsalve")
               customer.Transform:SetPosition(pt1.x+(math.random(30)-math.random(30)), 0, pt1.z+(math.random(30)-math.random(30)))
               customer.AnimState:SetBank("wilson")
               local names = {"wilson","wendy","wes","wickerbottom","willow","wolfgang","wx78"}
               local buildname = names[math.random(#names)]
               customer.AnimState:SetBuild(buildname)
               local hats = {"hat_bee","hat_beefalo","hat_bush","hat_earmuffs","hat_feather","hat_flower","hat_football","hat_miner","hat_ruins","hat_slurper","hat_slurtle","hat_spider","hat_straw","hat_top","hat_walrus","hat_winter"}
               local hat = hats[math.random(#hats)]
               customer.AnimState:OverrideSymbol("swap_hat", hat, "swap_hat")
               local armors = {"armor_grass","armor_marble","armor_onemanband","armor_ruins","armor_sanity","armor_slurper","armor_slurtleshell","armor_sweatervest","armor_trunkvest_summer","armor_trunkvest_winter","armor_wood"}
               local armor = armors[math.random(#armors)]
               customer.AnimState:OverrideSymbol("swap_body", armor, "swap_body")
               customer.AnimState:Show("HAT")
               customer.AnimState:Show("HAT_HAIR")
               customer.AnimState:Hide("HAIR_NOHAT")
               customer.AnimState:Hide("HAIR")
               customer.AnimState:Hide("ARM_carry")
               customer.AnimState:Show("ARM_normal")
               customer.AnimState:PlayAnimation("idle")
               customer.Transform:SetFourFaced()
               local sound = customer.entity:AddSoundEmitter()
               local shadow = customer.entity:AddDynamicShadow()
               shadow:SetSize( 1.3, .6 )
               customer:RemoveComponent("stackable")
               customer:RemoveComponent("inventoryitem")
               customer:RemoveComponent("healer")
               customer:RemoveComponent("deployable")
               customer:AddComponent("locomotor")
               customer.components.locomotor.walkspeed = 4
               customer.components.locomotor.runspeed = 8
               customer:SetStateGraph("SGshadowwaxwell")
               local brain = require "brains/frogbrain"
               customer:SetBrain(brain)
               customer:AddComponent("health")
               customer.components.health:SetMaxHealth(1000)
               customer.components.health:SetInvincible(true)
               customer.components.health.nofadeout = true
               customer:AddComponent("combat")
               customer:AddComponent("knownlocations")
               customer:AddTag("customers")
               customer:AddTag("goodbye")
               customer.task1 = customer:DoPeriodicTask(3, function(customer)
                   if math.random() < 0.1 then
                      local target = FindEntity(customer, 100, function(guy) 
                          return guy:HasTag("sweets") and guy.components.inventoryitem and not guy.components.inventoryitem:IsHeld()
                      end )
                      if target then
                         customer.components.locomotor:Stop()
                         customer:SetBrain(nil)
                         customer.components.locomotor:GoToEntity(target)
                         customer.task2 = customer:DoPeriodicTask(.25, function(customer)
                             local target2 = FindEntity(customer, 1, function(guy) 
                                 return guy:HasTag("sweets") and guy.components.inventoryitem and not guy.components.inventoryitem:IsHeld()
                             end )
                             if target2 then
                                customer.AnimState:PlayAnimation("pickup")
                                for k = 1, 6 do
                                    SpawnPrefab("goldnugget").Transform:SetPosition(target2.Transform:GetWorldPosition())
                                end
                                target2:Remove()
                                local brain = require "brains/frogbrain"
                                customer:SetBrain(brain)
                                customer:RestartBrain()
                                if customer.task2 then customer.task2:Cancel() customer.task2 = nil end
                             end
                         end )
                         customer:DoTaskInTime(8, function(customer)
                             local brain = require "brains/frogbrain"
                             customer:SetBrain(brain)
                             customer:RestartBrain()
                             if customer.task2 then customer.task2:Cancel() customer.task2 = nil end
                         end )
                      else
                         local brain = require "brains/frogbrain"
                         customer:SetBrain(brain)
                         customer:RestartBrain()
                         if customer.task2 then customer.task2:Cancel() customer.task2 = nil end
                      end
                   end
               end )
           end
        end
      else
        sweetsign:RemoveTag("openshop")
        GetPlayer().SoundEmitter:KillSound("beavermusic")
        sweetsign.AnimState:SetMultColour(255/255,0/255,0/255,1)
        local pos = Vector3(sweetsign.Transform:GetWorldPosition())
        local ents = TheSim:FindEntities(pos.x,pos.y,pos.z, 3000)
        for k,v in pairs(ents) do
            if v:HasTag("customers") then
               v:Remove()
            end
        end
      end
    end
end
local function OnDeploy (inst, pt)
    sweetshop(inst)
    inst.components.stackable:Get():Remove()
end
    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = OnDeploy
local function onsave(inst, data)
    if inst:HasTag("shop") then
        data.shop = true
    end
    if inst:HasTag("goodbye") then
        data.goodbye = true
    end
    if inst:HasTag("sweets") then
        data.sweets = true
    end
end
local function onload(inst, data)
    if data and data.shop then
       sweetshop(inst)
       inst:Remove()
    end
    if data and data.goodbye then
       inst:Remove()
    end
    if data and data.sweets then
       inst.AnimState:SetBank("food")
       inst.AnimState:SetBuild("cook_pot_food")
       inst.AnimState:PlayAnimation("fruitmedley", false)
       inst:RemoveComponent("stackable")
       inst:RemoveComponent("deployable")
       inst.components.healer:SetHealthAmount(TUNING.HEALING_SUPERHUGE)
       inst.components.inventoryitem:ChangeImageName("fruitmedley")
       inst.Transform:SetScale(1.2, 1.2, 1.2)
       inst:AddTag("sweets")
    end
end
    inst.OnSave = onsave
    inst.OnLoad = onload